# ProbTree
#
# ProbTree t@CtH[}bg
# --
# name,probs,nexts,values
# --
# name:: O
# probs:: mi󔒋؂j v100ɂ邱
# nexts::  ProbTreei󔒋؂j
# values:: li󔒋؂j
#
# probs ɑΉmƓ values ԂB
# values AΉl "-" ̏ꍇA
# Ή nexts  ProbTree Ăюs𑱂B
#

# m
# iɕꂽm̒l擾邽߂̃NX
# Data_Loader Parser_Base Kv
class ProbTree
  # 
  def initialize(filename='ProbTreeData',base_dir=[])
    @data = self.load(filename,base_dir)
  end

  # m̎擾
  def [](k)
    case k
    when String
      return get(k)
    when Regexp
      return gets(k)
    end
    return nil
  end

  # m̎擾
  def get(k)
    return @data[k]
  end

  # m̎擾iXgj
  def gets(reg)
    result = []
    @data.keys().sort().each() do |k|
      if k =~ reg
        result.push(@data[k])
      end
    end
    return result
  end

  # mt@C烍[h
  def load(filename='ProbTreeData',base_dir=[])
    opt = {
      'parser'=>::Parser::ProbTreeParser.new,
      'filename'=>filename,
      'base_dir'=>base_dir
    }
    result = {}
    # ǂݍ and RpC
    ptlist = Data_Loader.compile_object('ProbTreeData',opt)
    # OL[Ƀ}bvŊǗ
    ptlist.each do |pt|
      result[pt.name] = pt
    end
    # c[\֕ϊ
    ptlist.each do |pt|
      # f[^nextsŐݒ肳Ă閼OΉProbTreeɕϊ
      if not pt.nexts.nil?
        pt.nexts = pt.nexts.collect() do |k|
          k.split(/&/).collect() do |s|
            result[s]
          end
        end
      end
    end
    return result
  end
end

class ProbTreeData
  # O
  attr_accessor :name
  # mXg vPOOɂBex.[80,20]
  attr_accessor :probs
  # ProbTreeXg
  attr_accessor :nexts
  # ʂ̒l
  attr_accessor :values
  # 
  def initialize
    @probs = nil
    @nexts = nil
    @values = nil
  end

  # c[s
  # emɒlԂ
  def exec(result=[])
    if @probs.nil?
      return result
    end
    # m
    r = rand(100)
    # ǂ̊Ɉ邩H
    @probs.each_with_index do |prob,i|
      # ݂̊ȉ
      if r <= prob
        if not @values.nil?
          # lݒ肳Ăꍇ
          if not @values[i].nil?
            result.push(@values[i])
          end
        end
        if not @nexts.nil?
          # ̊ms
          if not @nexts[i].nil?
            case @nexts[i]
            when Array
              @nexts[i].each do |pt|
                if not pt.nil?
                  pt.exec(result)
                end
              end
            when ProbTree
              @nexts[i].exec(result)
            end
          end
        end
        break
      end
      # 𒴂ĂAĎ̊`FbN
      r -= prob
    end
    return result
  end
end

module Parser
  # mpp[T[
  # tH[}bg
  # name,probs,nexts,values
  # name:: ProbTree
  # probs:: 󔒋؂萔lAv100
  # nexts:: 󔒋؂蕶@ProbTreew probšɂ킹
  # values:: 󔒋؂蕶 probšɂ킹
  #@nexts,values@𗼕w肵ꍇ́AvaluefĎPropTreȅɂȂB
  class ProbTreeParser < Parser_Base
    # 
    def initialize
      super
      @names = ['name','probs','nexts','values']
      @klass = ::ProbTreeData
      add_parse('probs',:parse_nums)
      add_parse('nexts',:parse_splits)
      add_parse('values',:parse_values)
    end

    # lɕ
    def parse_nums(line)
      return nil if line.nil? or line == ""
      return line.split(/ +/).collect {|o|o.to_i}
    end

    # ɕ
    def parse_splits(line)
      return nil if line.nil? or line == ""
      return line.split(/ +/)
    end

    # l𕪊
    def parse_values(line)
      return nil if line.nil? or line == ""
      values = line.split(/ +/)
      if values.all?() {|v| v =~ /^-?[0-9]*$/}
        # SĐlɕϊłꍇ́Alɂ - ݂̂́Anull
        values = values.collect() {|v| v == '-' ? nil : v.to_i}
      else
        values = values.collect() {|v| v == '-' ? nil : v}
      end
      return values
    end
  end
end
